/*
 * Decompiled with CFR 0.152.
 */
package com.spawnerx.managers;

import com.spawnerx.SpawnerX;
import com.spawnerx.managers.SpawnerShopHolder;
import com.spawnerx.utils.ExperienceUtils;
import com.spawnerx.utils.SkullUtils;
import com.spawnerx.utils.SpawnerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SpawnerShopManager {
    public static final int SHOP_SIZE = 54;
    private static final int[] CONTENT_SLOTS = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34};
    private static final int SLOT_PREV = 45;
    private static final int SLOT_BACK = 48;
    private static final int SLOT_PAGE = 49;
    private static final int SLOT_NEXT = 53;
    private static final int SLOT_TITLE = 4;
    private final SpawnerX plugin;
    private final NamespacedKey shopEntityKey;
    private final NamespacedKey shopPriceKey;
    private final NamespacedKey shopCategoryKey;
    private final NamespacedKey shopNavKey;

    public SpawnerShopManager(SpawnerX plugin) {
        this.plugin = plugin;
        this.shopEntityKey = new NamespacedKey((Plugin)plugin, "shop_entity");
        this.shopPriceKey = new NamespacedKey((Plugin)plugin, "shop_price");
        this.shopCategoryKey = new NamespacedKey((Plugin)plugin, "shop_category");
        this.shopNavKey = new NamespacedKey((Plugin)plugin, "shop_nav");
    }

    public void openShop(Player player) {
        if (!this.plugin.getConfigManager().isShopEnabled()) {
            player.sendMessage(this.plugin.getLocaleManager().getMessage("shop.disabled"));
            return;
        }
        this.openCategories(player, 0);
    }

    public boolean isShopInventory(Inventory inventory) {
        return inventory.getHolder() instanceof SpawnerShopHolder;
    }

    public void handleClick(Player player, Inventory inventory, ItemStack clicked) {
        if (!(inventory.getHolder() instanceof SpawnerShopHolder)) {
            return;
        }
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        if (!this.plugin.getConfigManager().isShopEnabled()) {
            player.sendMessage(this.plugin.getLocaleManager().getMessage("shop.disabled"));
            return;
        }
        SpawnerShopHolder holder = (SpawnerShopHolder)inventory.getHolder();
        if (holder.getView() == SpawnerShopHolder.View.CATEGORIES) {
            this.handleCategoriesClick(player, holder, clicked);
        } else {
            this.handleCategoryClick(player, holder, clicked);
        }
    }

    private void handleCategoriesClick(Player player, SpawnerShopHolder holder, ItemStack clicked) {
        ItemMeta meta = clicked.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        String nav = (String)container.get(this.shopNavKey, PersistentDataType.STRING);
        if ("prev".equals(nav)) {
            this.openCategories(player, holder.getPage() - 1);
            return;
        }
        if ("next".equals(nav)) {
            this.openCategories(player, holder.getPage() + 1);
            return;
        }
        String categoryId = (String)container.get(this.shopCategoryKey, PersistentDataType.STRING);
        if (categoryId != null) {
            this.openCategory(player, categoryId, 0, holder.getPage());
        }
    }

    private void handleCategoryClick(Player player, SpawnerShopHolder holder, ItemStack clicked) {
        ItemMeta meta = clicked.getItemMeta();
        if (meta == null) {
            return;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        String nav = (String)container.get(this.shopNavKey, PersistentDataType.STRING);
        if ("prev".equals(nav)) {
            this.openCategory(player, holder.getCategoryId(), holder.getPage() - 1, holder.getParentPage());
            return;
        }
        if ("next".equals(nav)) {
            this.openCategory(player, holder.getCategoryId(), holder.getPage() + 1, holder.getParentPage());
            return;
        }
        if ("back".equals(nav)) {
            this.openCategories(player, holder.getParentPage());
            return;
        }
        String entityName = (String)container.get(this.shopEntityKey, PersistentDataType.STRING);
        Integer price = (Integer)container.get(this.shopPriceKey, PersistentDataType.INTEGER);
        if (entityName == null || price == null) {
            return;
        }
        EntityType type = SpawnerUtils.getEntityType(entityName);
        if (type == null || !SpawnerUtils.isMobEntityType(type)) {
            player.sendMessage(this.plugin.getLocaleManager().getMessage("shop.buy.invalid-item"));
            return;
        }
        int totalXp = ExperienceUtils.getTotalExperience(player);
        if (totalXp < price) {
            player.sendMessage(this.plugin.getLocaleManager().getMessage("shop.buy.not-enough-xp", "price", String.valueOf(price), "currency", this.plugin.getConfigManager().getShopCurrency()));
            return;
        }
        ExperienceUtils.setTotalExperience(player, totalXp - price);
        ItemStack spawner = this.plugin.getSpawnerManager().createSpawner(type, 1);
        player.getInventory().addItem(new ItemStack[]{spawner});
        String typeName = SpawnerUtils.getEntityDisplayName(type);
        player.sendMessage(this.plugin.getLocaleManager().getMessage("shop.buy.success", "type", typeName, "price", String.valueOf(price), "currency", this.plugin.getConfigManager().getShopCurrency()));
    }

    private void openCategories(Player player, int page) {
        List<ShopCategory> categories = this.loadCategories();
        PageLayout<ShopCategory> layout = this.buildPageLayout(categories);
        int totalPages = layout.totalPages;
        int currentPage = this.clampPage(page, totalPages);
        String title = this.plugin.getLocaleManager().getMessage("shop.title.categories");
        Inventory inventory = Bukkit.createInventory((InventoryHolder)new SpawnerShopHolder(SpawnerShopHolder.View.CATEGORIES, null, currentPage, 0), (int)54, (Component)LegacyComponentSerializer.legacyAmpersand().deserialize(title));
        this.fillBackground(inventory);
        this.placeTitleBar(inventory, title);
        this.placeNavigation(inventory, currentPage, totalPages, false);
        Map manual = layout.manualByPageSlot.get(currentPage);
        if (manual != null) {
            for (Map.Entry entry : manual.entrySet()) {
                inventory.setItem(entry.getKey().intValue(), this.createCategoryItem((ShopCategory)entry.getValue()));
            }
        }
        List<Integer> freeSlots = layout.freeSlotsByPage.get(currentPage);
        int start = layout.autoStartIndexByPage.get(currentPage);
        int end = Math.min(start + freeSlots.size(), layout.autoEntries.size());
        for (int i = start; i < end; ++i) {
            ShopCategory category = (ShopCategory)layout.autoEntries.get(i);
            int slot = freeSlots.get(i - start);
            inventory.setItem(slot, this.createCategoryItem(category));
        }
        player.openInventory(inventory);
    }

    private void openCategory(Player player, String categoryId, int page, int parentPage) {
        ShopCategory category = this.findCategory(categoryId);
        if (category == null) {
            this.openCategories(player, 0);
            return;
        }
        List<ShopItem> items = category.items;
        PageLayout<ShopItem> layout = this.buildPageLayout(items);
        int totalPages = layout.totalPages;
        int currentPage = this.clampPage(page, totalPages);
        String title = this.plugin.getLocaleManager().getMessage("shop.title.category", "category", category.title, "page", String.valueOf(currentPage + 1), "pages", String.valueOf(totalPages));
        Inventory inventory = Bukkit.createInventory((InventoryHolder)new SpawnerShopHolder(SpawnerShopHolder.View.CATEGORY, category.id, currentPage, parentPage), (int)54, (Component)LegacyComponentSerializer.legacyAmpersand().deserialize(title));
        this.fillBackground(inventory);
        this.placeTitleBar(inventory, category.title);
        this.placeNavigation(inventory, currentPage, totalPages, true);
        Map manual = layout.manualByPageSlot.get(currentPage);
        if (manual != null) {
            for (Map.Entry entry : manual.entrySet()) {
                inventory.setItem(entry.getKey().intValue(), this.createShopItem((ShopItem)entry.getValue()));
            }
        }
        List<Integer> freeSlots = layout.freeSlotsByPage.get(currentPage);
        int start = layout.autoStartIndexByPage.get(currentPage);
        int end = Math.min(start + freeSlots.size(), layout.autoEntries.size());
        for (int i = start; i < end; ++i) {
            ShopItem item = (ShopItem)layout.autoEntries.get(i);
            int slot = freeSlots.get(i - start);
            inventory.setItem(slot, this.createShopItem(item));
        }
        player.openInventory(inventory);
    }

    private void placeNavigation(Inventory inventory, int page, int totalPages, boolean showBack) {
        ItemStack pageItem;
        ItemMeta meta;
        String backHead;
        if (totalPages > 1 && page > 0) {
            inventory.setItem(45, this.createNavItem("prev", this.plugin.getConfigManager().getShopNavHead("prev-head"), this.plugin.getLocaleManager().getMessage("shop.nav.prev")));
        }
        if (totalPages > 1 && page < totalPages - 1) {
            inventory.setItem(53, this.createNavItem("next", this.plugin.getConfigManager().getShopNavHead("next-head"), this.plugin.getLocaleManager().getMessage("shop.nav.next")));
        }
        if (showBack && (backHead = this.plugin.getConfigManager().getShopNavHead("back-head")) != null && !backHead.isBlank()) {
            inventory.setItem(48, this.createNavItem("back", backHead, this.plugin.getLocaleManager().getMessage("shop.nav.back")));
        }
        if ((meta = (pageItem = new ItemStack(Material.PAPER)).getItemMeta()) != null) {
            meta.displayName((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getLocaleManager().getMessage("shop.nav.page", "page", String.valueOf(page + 1), "pages", String.valueOf(totalPages))));
            pageItem.setItemMeta(meta);
        }
        inventory.setItem(49, pageItem);
    }

    private void fillBackground(Inventory inventory) {
        Material primaryMat = this.parseMaterial(this.plugin.getConfigManager().getShopFillerPrimary(), Material.BLUE_STAINED_GLASS_PANE);
        Material secondaryMat = this.parseMaterial(this.plugin.getConfigManager().getShopFillerSecondary(), Material.LIGHT_BLUE_STAINED_GLASS_PANE);
        Material accentMat = this.parseMaterial(this.plugin.getConfigManager().getShopFillerAccent(), Material.SEA_LANTERN);
        ItemStack primary = this.createFiller(primaryMat);
        ItemStack secondary = this.createFiller(secondaryMat);
        ItemStack accent = this.createFiller(accentMat);
        int size = inventory.getSize();
        for (int slot = 0; slot < size; ++slot) {
            boolean inner;
            int row = slot / 9;
            int col = slot % 9;
            boolean outer = row == 0 || row == 5 || col == 0 || col == 8;
            boolean corner = !(row != 0 && row != 5 || col != 0 && col != 8);
            boolean edgeAccent = !(col != 0 && col != 8 || row != 2 && row != 3);
            boolean bl = inner = row == 1 || row == 4;
            if (corner) {
                inventory.setItem(slot, accent);
                continue;
            }
            if (edgeAccent) {
                inventory.setItem(slot, accent);
                continue;
            }
            if (outer) {
                inventory.setItem(slot, primary);
                continue;
            }
            if (inner) {
                inventory.setItem(slot, secondary);
                continue;
            }
            inventory.setItem(slot, secondary);
        }
    }

    private void placeTitleBar(Inventory inventory, String title) {
        Material titleMaterial = this.parseMaterial(this.plugin.getConfigManager().getShopTitleItem(), Material.SPAWNER);
        ItemStack item = new ItemStack(titleMaterial);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(title));
            item.setItemMeta(meta);
        }
        inventory.setItem(4, item);
    }

    private ItemStack createFiller(Material material) {
        ItemStack filler = new ItemStack(material);
        ItemMeta meta = filler.getItemMeta();
        if (meta != null) {
            meta.displayName((Component)Component.text((String)" "));
            filler.setItemMeta(meta);
        }
        return filler;
    }

    private ItemStack createNavItem(String nav, String headBase64, String name) {
        ItemStack head = SkullUtils.createSkull(headBase64);
        ItemMeta meta = head.getItemMeta();
        if (meta != null) {
            meta.displayName((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(name));
            meta.getPersistentDataContainer().set(this.shopNavKey, PersistentDataType.STRING, (Object)nav);
            head.setItemMeta(meta);
        }
        return head;
    }

    private ItemStack createCategoryItem(ShopCategory category) {
        ItemStack item = category.iconHead != null && !category.iconHead.isBlank() ? SkullUtils.createSkull(category.iconHead) : (category.iconMaterial != null && !category.iconMaterial.isBlank() ? new ItemStack(this.parseMaterial(category.iconMaterial, Material.BOOK)) : new ItemStack(Material.BOOK));
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(category.title));
            ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
            lore.add(LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getLocaleManager().getMessage("shop.category.lore")));
            meta.lore(lore);
            meta.getPersistentDataContainer().set(this.shopCategoryKey, PersistentDataType.STRING, (Object)category.id);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createShopItem(ShopItem item) {
        ItemStack display = item.head != null && !item.head.isBlank() ? SkullUtils.createSkull(item.head) : (item.material != null && !item.material.isBlank() ? new ItemStack(this.parseMaterial(item.material, Material.SPAWNER)) : this.plugin.getSpawnerManager().createSpawner(item.type, 1));
        ItemMeta meta = display.getItemMeta();
        if (meta == null) {
            return display;
        }
        String displayName = this.plugin.getSpawnerManager().formatSpawnerDisplayName(item.type, 1);
        String typeName = SpawnerUtils.getEntityDisplayName(item.type);
        String name = this.plugin.getLocaleManager().getMessage("shop.item.name", "display_name", displayName, "type", typeName);
        meta.displayName((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(name));
        ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
        List<String> loreLines = this.buildItemLore(item, displayName, typeName);
        for (String line : loreLines) {
            lore.add(LegacyComponentSerializer.legacyAmpersand().deserialize(this.replaceLorePlaceholders(line, item, displayName, typeName)));
        }
        meta.lore(lore);
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(this.shopEntityKey, PersistentDataType.STRING, (Object)item.type.name());
        container.set(this.shopPriceKey, PersistentDataType.INTEGER, (Object)item.price);
        display.setItemMeta(meta);
        return display;
    }

    private List<ShopCategory> loadCategories() {
        ArrayList<ShopCategory> categories = new ArrayList<ShopCategory>();
        ConfigurationSection section = this.plugin.getConfigManager().getShopCategoriesSection();
        if (section == null) {
            return categories;
        }
        for (String key : section.getKeys(false)) {
            ConfigurationSection cat = section.getConfigurationSection(key);
            if (cat == null) continue;
            String title = cat.getString("title", key);
            String iconHead = cat.getString("icon-head", "");
            String iconMaterial = cat.getString("icon-material", "");
            int catSlot = cat.getInt("slot", -1);
            int catPage = cat.getInt("page", 0);
            ArrayList<ShopItem> items = new ArrayList<ShopItem>();
            ConfigurationSection itemsSection = cat.getConfigurationSection("items");
            if (itemsSection != null) {
                for (String mobKey : itemsSection.getKeys(false)) {
                    int price;
                    ConfigurationSection itemSection = itemsSection.getConfigurationSection(mobKey);
                    String head = "";
                    String material = "";
                    int slot = -1;
                    int page = 0;
                    ArrayList<String> lore = new ArrayList<String>();
                    if (itemSection != null) {
                        price = itemSection.getInt("price", -1);
                        head = itemSection.getString("head", "");
                        material = itemSection.getString("material", "");
                        slot = itemSection.getInt("slot", -1);
                        page = itemSection.getInt("page", 0);
                        if (itemSection.isList("lore")) {
                            lore.addAll(itemSection.getStringList("lore"));
                        } else {
                            String loreRaw = itemSection.getString("lore", "");
                            if (!loreRaw.isBlank()) {
                                for (String line : loreRaw.split("\\\\n")) {
                                    lore.add(line);
                                }
                            }
                        }
                    } else {
                        price = itemsSection.getInt(mobKey, -1);
                    }
                    if (price <= 0) continue;
                    EntityType type = SpawnerUtils.getEntityType(mobKey);
                    if (type == null || !SpawnerUtils.isMobEntityType(type)) {
                        this.plugin.getLogger().warning("Mob inv\u00e1lido no shop: " + mobKey);
                        continue;
                    }
                    items.add(new ShopItem(type, price, head, material, slot, page, lore));
                }
            }
            categories.add(new ShopCategory(key, title, iconHead, iconMaterial, items, catSlot, catPage));
        }
        return categories;
    }

    private ShopCategory findCategory(String id) {
        for (ShopCategory category : this.loadCategories()) {
            if (!category.id.equalsIgnoreCase(id)) continue;
            return category;
        }
        return null;
    }

    private int clampPage(int page, int totalPages) {
        if (page < 0) {
            return 0;
        }
        if (page >= totalPages) {
            return totalPages - 1;
        }
        return page;
    }

    private Material parseMaterial(String name, Material fallback) {
        if (name == null || name.isBlank()) {
            return fallback;
        }
        try {
            return Material.valueOf((String)name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return fallback;
        }
    }

    private List<String> buildItemLore(ShopItem item, String displayName, String typeName) {
        if (item.lore != null && !item.lore.isEmpty()) {
            return item.lore;
        }
        String loreRaw = this.plugin.getLocaleManager().getMessage("shop.item.lore", "price", String.valueOf(item.price), "currency", this.plugin.getConfigManager().getShopCurrency());
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : loreRaw.split("\\\\n")) {
            lines.add(line);
        }
        return lines;
    }

    private String replaceLorePlaceholders(String line, ShopItem item, String displayName, String typeName) {
        return line.replace("{price}", String.valueOf(item.price)).replace("{currency}", this.plugin.getConfigManager().getShopCurrency()).replace("{type}", typeName).replace("{display_name}", displayName);
    }

    private boolean isBlockedSlot(int slot) {
        return slot < 0 || slot >= 54 || slot == 45 || slot == 53 || slot == 48 || slot == 49 || slot == 4;
    }

    private <T extends SlotEntry> PageLayout<T> buildPageLayout(List<T> entries) {
        ArrayList<Integer> freeSlots;
        ArrayList<SlotEntry> autoEntries = new ArrayList<SlotEntry>();
        HashMap manualByPageSlot = new HashMap();
        int maxManualPage = 0;
        for (SlotEntry entry : entries) {
            if (!entry.hasManualSlot()) {
                autoEntries.add(entry);
                continue;
            }
            int slot = entry.getSlot();
            int page = Math.max(0, entry.getPage());
            if (this.isBlockedSlot(slot)) {
                this.plugin.getLogger().warning("Shop slot " + slot + " is blocked; using auto placement instead.");
                autoEntries.add(entry);
                continue;
            }
            Object pageMap = manualByPageSlot.computeIfAbsent(page, k -> new HashMap());
            if (pageMap.containsKey(slot)) {
                this.plugin.getLogger().warning("Duplicate shop slot " + slot + " on page " + page + "; using auto placement.");
                autoEntries.add(entry);
                continue;
            }
            pageMap.put(slot, entry);
            if (page <= maxManualPage) continue;
            maxManualPage = page;
        }
        ArrayList<List<Integer>> freeSlotsByPage = new ArrayList<List<Integer>>();
        int remainingAuto = autoEntries.size();
        for (int page = 0; page <= maxManualPage || remainingAuto > 0; remainingAuto -= freeSlots.size(), ++page) {
            freeSlots = new ArrayList<Integer>();
            for (int slot : CONTENT_SLOTS) {
                freeSlots.add(slot);
            }
            Map manualSlots = (Map)manualByPageSlot.get(page);
            if (manualSlots != null) {
                freeSlots.removeIf(manualSlots::containsKey);
            }
            freeSlotsByPage.add(freeSlots);
        }
        ArrayList<Integer> autoStartIndexByPage = new ArrayList<Integer>();
        int index = 0;
        for (List list : freeSlotsByPage) {
            autoStartIndexByPage.add(index);
            index += list.size();
        }
        return new PageLayout(autoEntries, manualByPageSlot, freeSlotsByPage, autoStartIndexByPage, freeSlotsByPage.size());
    }

    private static class PageLayout<T extends SlotEntry> {
        private final List<T> autoEntries;
        private final Map<Integer, Map<Integer, T>> manualByPageSlot;
        private final List<List<Integer>> freeSlotsByPage;
        private final List<Integer> autoStartIndexByPage;
        private final int totalPages;

        private PageLayout(List<T> autoEntries, Map<Integer, Map<Integer, T>> manualByPageSlot, List<List<Integer>> freeSlotsByPage, List<Integer> autoStartIndexByPage, int totalPages) {
            this.autoEntries = autoEntries;
            this.manualByPageSlot = manualByPageSlot;
            this.freeSlotsByPage = freeSlotsByPage;
            this.autoStartIndexByPage = autoStartIndexByPage;
            this.totalPages = totalPages;
        }
    }

    private static class ShopCategory
    implements SlotEntry {
        private final String id;
        private final String title;
        private final String iconHead;
        private final String iconMaterial;
        private final List<ShopItem> items;
        private final int slot;
        private final int page;

        private ShopCategory(String id, String title, String iconHead, String iconMaterial, List<ShopItem> items, int slot, int page) {
            this.id = id;
            this.title = title;
            this.iconHead = iconHead;
            this.iconMaterial = iconMaterial;
            this.items = items;
            this.slot = slot;
            this.page = page;
        }

        @Override
        public int getSlot() {
            return this.slot;
        }

        @Override
        public int getPage() {
            return this.page;
        }
    }

    private static class ShopItem
    implements SlotEntry {
        private final EntityType type;
        private final int price;
        private final String head;
        private final String material;
        private final int slot;
        private final int page;
        private final List<String> lore;

        private ShopItem(EntityType type, int price, String head, String material, int slot, int page, List<String> lore) {
            this.type = type;
            this.price = price;
            this.head = head;
            this.material = material;
            this.slot = slot;
            this.page = page;
            this.lore = lore;
        }

        @Override
        public int getSlot() {
            return this.slot;
        }

        @Override
        public int getPage() {
            return this.page;
        }
    }

    private static interface SlotEntry {
        public int getSlot();

        public int getPage();

        default public boolean hasManualSlot() {
            return this.getSlot() >= 0;
        }
    }
}

