/*
 * Decompiled with CFR 0.152.
 */
package com.spawnerx.managers;

import com.spawnerx.SpawnerX;
import com.spawnerx.utils.SpawnerUtils;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SpawnerManager {
    private final SpawnerX plugin;
    private final NamespacedKey entityKey;
    private final NamespacedKey ownerKey;
    private final NamespacedKey stackKey;
    private final NamespacedKey baseSpawnCountKey;
    private final NamespacedKey baseMaxNearbyKey;
    private final NamespacedKey hologramKey;
    private static final double HOLOGRAM_Y_OFFSET = 1.2;

    public SpawnerManager(SpawnerX plugin) {
        this.plugin = plugin;
        this.entityKey = new NamespacedKey((Plugin)plugin, "spawner_entity");
        this.ownerKey = new NamespacedKey((Plugin)plugin, "spawner_owner");
        this.stackKey = new NamespacedKey((Plugin)plugin, "spawner_stack");
        this.baseSpawnCountKey = new NamespacedKey((Plugin)plugin, "spawner_base_spawn_count");
        this.baseMaxNearbyKey = new NamespacedKey((Plugin)plugin, "spawner_base_max_nearby");
        this.hologramKey = new NamespacedKey((Plugin)plugin, "spawner_hologram_id");
    }

    public ItemStack createSpawner(EntityType entityType) {
        return this.createSpawner(entityType, 1);
    }

    public ItemStack createSpawner(EntityType entityType, int stackSize) {
        ItemStack spawner = new ItemStack(Material.SPAWNER);
        BlockStateMeta meta = (BlockStateMeta)spawner.getItemMeta();
        if (meta != null) {
            CreatureSpawner spawnerState = (CreatureSpawner)meta.getBlockState();
            spawnerState.setSpawnedType(entityType);
            meta.setBlockState((BlockState)spawnerState);
            PersistentDataContainer container = meta.getPersistentDataContainer();
            container.set(this.entityKey, PersistentDataType.STRING, (Object)entityType.name());
            container.set(this.stackKey, PersistentDataType.INTEGER, (Object)stackSize);
            String entityName = SpawnerUtils.getEntityDisplayName(entityType);
            String rarity = this.plugin.getConfigManager().getRarity(entityType.name());
            String rarityClean = rarity.replaceAll("&[0-9a-fk-or]", "");
            String rarityColor = this.extractColorCode(rarity);
            String baseName = this.plugin.getConfigManager().getSpawnerDisplayName().replace("{type}", entityName).replace("{rarity}", rarityClean).replace("{rarity_color}", rarityColor).replace("{stack_size}", String.valueOf(stackSize));
            String displayName = stackSize + "x " + baseName;
            meta.displayName((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(displayName));
            List<String> loreTemplate = this.plugin.getConfigManager().getSpawnerLore();
            List lore = loreTemplate.stream().map(line -> LegacyComponentSerializer.legacyAmpersand().deserialize(line.replace("{type}", entityName).replace("{rarity}", rarityClean).replace("{rarity_color}", rarityColor).replace("{stack_size}", String.valueOf(stackSize)))).collect(Collectors.toList());
            meta.lore(lore);
            spawner.setItemMeta((ItemMeta)meta);
        }
        return spawner;
    }

    public void applyStackToSpawner(CreatureSpawner spawner, int stackSize) {
        if (spawner == null) {
            return;
        }
        PersistentDataContainer container = spawner.getPersistentDataContainer();
        int baseSpawn = this.getOrStoreBase(container, this.baseSpawnCountKey, spawner.getSpawnCount());
        int baseMaxNearby = this.getOrStoreBase(container, this.baseMaxNearbyKey, spawner.getMaxNearbyEntities());
        int safeStack = Math.max(1, stackSize);
        int newSpawn = Math.max(1, baseSpawn * safeStack);
        int newMaxNearby = Math.max(1, baseMaxNearby * safeStack);
        spawner.setSpawnCount(newSpawn);
        spawner.setMaxNearbyEntities(newMaxNearby);
    }

    public void updateSpawnerHologram(Block block, EntityType entityType, int stackSize) {
        if (block == null || block.getType() != Material.SPAWNER) {
            return;
        }
        CreatureSpawner spawner = (CreatureSpawner)block.getState();
        PersistentDataContainer container = spawner.getPersistentDataContainer();
        TextComponent text = LegacyComponentSerializer.legacyAmpersand().deserialize(this.formatSpawnerDisplayName(entityType, stackSize));
        TextDisplay display = this.getExistingHologram(block.getWorld(), container);
        Location location = block.getLocation().add(0.5, 1.2, 0.5);
        if (display == null || display.isDead()) {
            display = this.spawnHologram(block.getWorld(), location, (Component)text);
            container.set(this.hologramKey, PersistentDataType.STRING, (Object)display.getUniqueId().toString());
        } else {
            display.text((Component)text);
            display.teleport(location);
        }
        spawner.update();
    }

    public void removeSpawnerHologram(Block block) {
        if (block == null || block.getType() != Material.SPAWNER) {
            return;
        }
        CreatureSpawner spawner = (CreatureSpawner)block.getState();
        PersistentDataContainer container = spawner.getPersistentDataContainer();
        TextDisplay display = this.getExistingHologram(block.getWorld(), container);
        if (display != null) {
            display.remove();
        }
        container.remove(this.hologramKey);
        spawner.update();
    }

    public String formatSpawnerDisplayName(EntityType entityType, int stackSize) {
        String entityName = SpawnerUtils.getEntityDisplayName(entityType);
        String rarity = this.plugin.getConfigManager().getRarity(entityType.name());
        String rarityClean = rarity.replaceAll("&[0-9a-fk-or]", "");
        String rarityColor = this.extractColorCode(rarity);
        String baseName = this.plugin.getConfigManager().getSpawnerDisplayName().replace("{type}", entityName).replace("{rarity}", rarityClean).replace("{rarity_color}", rarityColor).replace("{stack_size}", String.valueOf(stackSize));
        return stackSize + "x " + baseName;
    }

    public EntityType getSpawnerEntity(ItemStack item) {
        if (item == null || item.getType() != Material.SPAWNER) {
            return null;
        }
        BlockStateMeta meta = (BlockStateMeta)item.getItemMeta();
        if (meta == null) {
            return null;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        if (container.has(this.entityKey, PersistentDataType.STRING)) {
            try {
                return EntityType.valueOf((String)((String)container.get(this.entityKey, PersistentDataType.STRING)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        CreatureSpawner spawnerState = (CreatureSpawner)meta.getBlockState();
        return spawnerState.getSpawnedType();
    }

    public boolean isValidSpawner(ItemStack item) {
        if (item == null || item.getType() != Material.SPAWNER) {
            return false;
        }
        BlockStateMeta meta = (BlockStateMeta)item.getItemMeta();
        if (meta != null) {
            PersistentDataContainer container = meta.getPersistentDataContainer();
            return container.has(this.entityKey, PersistentDataType.STRING);
        }
        return false;
    }

    public int getSpawnerStack(ItemStack item) {
        if (item == null || item.getType() != Material.SPAWNER) {
            return 1;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return 1;
        }
        PersistentDataContainer container = meta.getPersistentDataContainer();
        return (Integer)container.getOrDefault(this.stackKey, PersistentDataType.INTEGER, (Object)1);
    }

    public NamespacedKey getEntityKey() {
        return this.entityKey;
    }

    public NamespacedKey getOwnerKey() {
        return this.ownerKey;
    }

    public NamespacedKey getStackKey() {
        return this.stackKey;
    }

    private int getOrStoreBase(PersistentDataContainer container, NamespacedKey key, int current) {
        if (!container.has(key, PersistentDataType.INTEGER)) {
            container.set(key, PersistentDataType.INTEGER, (Object)current);
            return current;
        }
        return (Integer)container.getOrDefault(key, PersistentDataType.INTEGER, (Object)current);
    }

    private TextDisplay getExistingHologram(World world, PersistentDataContainer container) {
        String id = (String)container.get(this.hologramKey, PersistentDataType.STRING);
        if (id == null || id.isBlank()) {
            return null;
        }
        try {
            UUID uuid = UUID.fromString(id);
            Entity entity = world.getEntity(uuid);
            if (entity instanceof TextDisplay) {
                return (TextDisplay)entity;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    private TextDisplay spawnHologram(World world, Location location, Component text) {
        return (TextDisplay)world.spawn(location, TextDisplay.class, display -> {
            display.text(text);
            display.setBillboard(Display.Billboard.CENTER);
            display.setGravity(false);
        });
    }

    private String extractColorCode(String rarity) {
        int idx = rarity.indexOf("&");
        if (idx >= 0 && idx + 1 < rarity.length()) {
            return rarity.substring(idx, idx + 2);
        }
        return "&f";
    }
}

