/*
 * Decompiled with CFR 0.152.
 */
package com.spawnerx.managers;

import com.spawnerx.SpawnerX;
import java.io.File;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LocaleManager {
    private final SpawnerX plugin;
    private FileConfiguration localeConfig;
    private FileConfiguration fallbackConfig;

    public LocaleManager(SpawnerX plugin) {
        this.plugin = plugin;
    }

    public void loadLocale() {
        this.saveAllLocaleResources();
        File fallbackFile = new File(this.plugin.getDataFolder(), "locale/en_US.yml");
        if (!fallbackFile.exists()) {
            this.plugin.saveResource("locale/en_US.yml", false);
        }
        this.fallbackConfig = YamlConfiguration.loadConfiguration((File)fallbackFile);
        String locale = this.plugin.getConfigManager().getLocale();
        File localeFile = new File(this.plugin.getDataFolder(), "locale/" + locale + ".yml");
        if (!localeFile.getParentFile().exists()) {
            localeFile.getParentFile().mkdirs();
        }
        if (!localeFile.exists()) {
            try {
                this.plugin.saveResource("locale/" + locale + ".yml", false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.localeConfig = localeFile.exists() ? YamlConfiguration.loadConfiguration((File)localeFile) : this.fallbackConfig;
    }

    private void saveAllLocaleResources() {
        try {
            File pluginFile = new File(((Object)((Object)this.plugin)).getClass().getProtectionDomain().getCodeSource().getLocation().toURI());
            JarFile jar = new JarFile(pluginFile);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                File outFile;
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("locale/") || !name.endsWith(".yml") || (outFile = new File(this.plugin.getDataFolder(), name)).exists()) continue;
                this.plugin.saveResource(name, false);
            }
            jar.close();
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Falha ao copiar locales do JAR: " + e.getMessage());
        }
    }

    public String getMessage(String path) {
        String message = this.localeConfig.getString(path);
        if (message == null) {
            message = this.fallbackConfig.getString(path, path);
        }
        if (!path.equals("prefix")) {
            String prefix = this.getRawMessage("prefix");
            message = message.replace("{prefix}", prefix);
        }
        return this.colorize(message);
    }

    private String getRawMessage(String path) {
        String message = this.localeConfig.getString(path);
        if (message == null) {
            message = this.fallbackConfig.getString(path, path);
        }
        return message;
    }

    public String getMessage(String path, String ... replacements) {
        String message = this.getRawMessage(path);
        if (!path.equals("prefix")) {
            String prefix = this.getRawMessage("prefix");
            message = message.replace("{prefix}", prefix);
        }
        for (int i = 0; i < replacements.length - 1; i += 2) {
            message = message.replace("{" + replacements[i] + "}", replacements[i + 1]);
        }
        return this.colorize(message);
    }

    private String colorize(String text) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public FileConfiguration getLocaleConfig() {
        return this.localeConfig;
    }
}

