/*
 * Decompiled with CFR 0.152.
 */
package com.spawnerx.managers;

import com.spawnerx.SpawnerX;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final SpawnerX plugin;
    private FileConfiguration config;
    private FileConfiguration shopConfig;
    private File shopFile;

    public ConfigManager(SpawnerX plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        this.plugin.saveDefaultConfig();
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.loadShopConfig();
        this.migrateConfig();
    }

    private void loadShopConfig() {
        if (this.shopFile == null) {
            this.shopFile = new File(this.plugin.getDataFolder(), "shop.yml");
        }
        if (!this.shopFile.exists()) {
            this.plugin.saveResource("shop.yml", false);
        }
        this.shopConfig = YamlConfiguration.loadConfiguration((File)this.shopFile);
        InputStream defaultStream = this.plugin.getResource("shop.yml");
        if (defaultStream != null) {
            YamlConfiguration defaults = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream, StandardCharsets.UTF_8));
            this.shopConfig.setDefaults((Configuration)defaults);
            this.shopConfig.options().copyDefaults(true);
            this.saveShopConfig();
        }
    }

    private void saveShopConfig() {
        try {
            if (this.shopConfig != null && this.shopFile != null) {
                this.shopConfig.save(this.shopFile);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Erro ao salvar shop.yml: " + e.getMessage());
        }
    }

    private void migrateConfig() {
        ConfigurationSection oldItems;
        Object shopSection;
        Object raritiesSection;
        boolean changed = false;
        boolean shopChanged = false;
        if (this.config.contains("break.required-tool")) {
            String oldTool = this.config.getString("break.required-tool");
            ArrayList<String> tools = this.config.getStringList("break.tools");
            if (tools.isEmpty()) {
                tools = new ArrayList<String>();
                tools.add(oldTool);
                this.config.set("break.tools", tools);
            }
            this.config.set("break.required-tool", null);
            changed = true;
        }
        if (this.config.contains("break.require-silk-touch")) {
            this.config.set("break.silk-touch", (Object)this.config.getBoolean("break.require-silk-touch"));
            this.config.set("break.require-silk-touch", null);
            changed = true;
        }
        if (this.config.contains("spawner.rarities") && !this.config.contains("rarities") && (raritiesSection = this.config.get("spawner.rarities")) != null) {
            this.config.set("rarities", raritiesSection);
            this.config.set("spawner.rarities", null);
            changed = true;
        }
        if (this.config.contains("spawner.shop") && (this.shopConfig == null || !this.shopConfig.contains("spawner.shop")) && (shopSection = this.config.get("spawner.shop")) != null && this.shopConfig != null) {
            this.shopConfig.set("spawner.shop", shopSection);
            shopChanged = true;
        }
        if (this.shopConfig != null && this.shopConfig.contains("spawner.shop.items") && !this.shopConfig.contains("spawner.shop.categories") && (oldItems = this.shopConfig.getConfigurationSection("spawner.shop.items")) != null) {
            String basePath = "spawner.shop.categories.DEFAULT";
            if (!this.shopConfig.contains(basePath + ".title")) {
                this.shopConfig.set(basePath + ".title", (Object)"&eDefault Spawners");
            }
            if (!this.shopConfig.contains(basePath + ".icon-head")) {
                this.shopConfig.set(basePath + ".icon-head", (Object)"");
            }
            for (String key : oldItems.getKeys(false)) {
                int price = oldItems.getInt(key, -1);
                if (price <= 0) continue;
                this.shopConfig.set(basePath + ".items." + key + ".price", (Object)price);
            }
            this.shopConfig.set("spawner.shop.items", null);
            shopChanged = true;
        }
        if (changed) {
            this.plugin.saveConfig();
            this.plugin.getLogger().info("Configura\u00e7\u00f5es migradas para o novo formato (prompt.md)");
        }
        if (shopChanged) {
            this.saveShopConfig();
        }
    }

    public String getLocale() {
        String locale = this.config.getString("locale", "pt_BR");
        return locale.replace("-", "_");
    }

    public List<Material> getValidTools() {
        List toolNames = this.config.getStringList("break.tools");
        if (toolNames.isEmpty()) {
            ArrayList<Material> defaultTools = new ArrayList<Material>();
            defaultTools.add(Material.DIAMOND_PICKAXE);
            return defaultTools;
        }
        return toolNames.stream().map(name -> {
            try {
                return Material.valueOf((String)name);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public boolean requiresSilkTouch() {
        return this.config.getBoolean("break.silk-touch", true);
    }

    public boolean isBreakDropToInventory() {
        return this.config.getBoolean("break.drop-to-inventory", true);
    }

    public double getBreakDropChance() {
        return this.config.getDouble("break.drop-chance", 50.0);
    }

    public boolean isExplosionDropAllowed() {
        return this.config.getBoolean("explosion.allow-drop", true);
    }

    public boolean isExplosionDropToInventory() {
        return this.config.getBoolean("explosion.drop-to-inventory", true);
    }

    public double getExplosionDropChance() {
        return this.config.getDouble("explosion.drop-chance", 50.0);
    }

    public boolean isAllowBreakWithoutRequirements() {
        return this.config.getBoolean("break.allow-break-without-requirements", true);
    }

    public boolean isStackingEnabled() {
        return this.config.getBoolean("spawner.stacking-enabled", true);
    }

    public int getMaxStackSize() {
        return this.config.getInt("spawner.max-stack-size", 64);
    }

    public String getSpawnerDisplayName() {
        return this.config.getString("spawner.display-name", "&8[{rarity_color}&l{rarity}&8] &e{type} Spawner");
    }

    public List<String> getSpawnerLore() {
        return this.config.getStringList("spawner.lore");
    }

    public int getSpawnerActiveDistance() {
        return this.config.getInt("spawner.distance-active", 64);
    }

    public boolean isShopEnabled() {
        return this.shopConfig != null && this.shopConfig.getBoolean("spawner.shop.enabled", false);
    }

    public String getShopCurrency() {
        return this.shopConfig != null ? this.shopConfig.getString("spawner.shop.currency", "XP") : "XP";
    }

    public String getShopFillerPrimary() {
        if (this.shopConfig == null) {
            return "BLUE_STAINED_GLASS_PANE";
        }
        return this.shopConfig.getString("spawner.shop.navigation.filler-primary", this.shopConfig.getString("spawner.shop.navigation.filler", "BLUE_STAINED_GLASS_PANE"));
    }

    public String getShopFillerSecondary() {
        if (this.shopConfig == null) {
            return "LIGHT_BLUE_STAINED_GLASS_PANE";
        }
        return this.shopConfig.getString("spawner.shop.navigation.filler-secondary", this.shopConfig.getString("spawner.shop.navigation.filler", "LIGHT_BLUE_STAINED_GLASS_PANE"));
    }

    public String getShopFillerAccent() {
        return this.shopConfig != null ? this.shopConfig.getString("spawner.shop.navigation.filler-accent", "SEA_LANTERN") : "SEA_LANTERN";
    }

    public String getShopTitleItem() {
        return this.shopConfig != null ? this.shopConfig.getString("spawner.shop.navigation.title-item", "SPAWNER") : "SPAWNER";
    }

    public String getShopNavHead(String key) {
        return this.shopConfig != null ? this.shopConfig.getString("spawner.shop.navigation." + key, "") : "";
    }

    public ConfigurationSection getShopCategoriesSection() {
        return this.shopConfig != null ? this.shopConfig.getConfigurationSection("spawner.shop.categories") : null;
    }

    public String getRarity(String entityType) {
        return this.config.getString("rarities." + entityType, this.config.getString("rarities.DEFAULT", "&fComum"));
    }

    public FileConfiguration getConfig() {
        return this.config;
    }
}

