/*
 * Decompiled with CFR 0.152.
 */
package com.spawnerx.listeners;

import com.spawnerx.SpawnerX;
import com.spawnerx.utils.SpawnerUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class SpawnerPlaceListener
implements Listener {
    private final SpawnerX plugin;

    public SpawnerPlaceListener(SpawnerX plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onSpawnerPlace(BlockPlaceEvent event) {
        PersistentDataContainer targetContainer;
        int currentStack;
        CreatureSpawner targetSpawner;
        Block blockPlaced = event.getBlockPlaced();
        Block blockAgainst = event.getBlockAgainst();
        if (blockPlaced.getType() != Material.SPAWNER) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = event.getItemInHand();
        if (!this.plugin.getSpawnerManager().isValidSpawner(item)) {
            return;
        }
        EntityType entityType = this.plugin.getSpawnerManager().getSpawnerEntity(item);
        if (entityType == null) {
            return;
        }
        int itemStackSize = this.plugin.getSpawnerManager().getSpawnerStack(item);
        int maxStack = this.plugin.getConfigManager().getMaxStackSize();
        if (this.plugin.getConfigManager().isStackingEnabled() && blockAgainst.getType() == Material.SPAWNER && (targetSpawner = (CreatureSpawner)blockAgainst.getState()).getSpawnedType() == entityType && (currentStack = ((Integer)(targetContainer = targetSpawner.getPersistentDataContainer()).getOrDefault(this.plugin.getSpawnerManager().getStackKey(), PersistentDataType.INTEGER, (Object)1)).intValue()) < maxStack) {
            event.setCancelled(true);
            int newStack = currentStack + itemStackSize;
            int appliedStack = Math.min(newStack, maxStack);
            int remaining = newStack - appliedStack;
            targetContainer.set(this.plugin.getSpawnerManager().getStackKey(), PersistentDataType.INTEGER, (Object)appliedStack);
            this.plugin.getSpawnerManager().applyStackToSpawner(targetSpawner, appliedStack);
            targetSpawner.update();
            this.plugin.getSpawnerManager().updateSpawnerHologram(blockAgainst, entityType, appliedStack);
            this.consumeItem(player, item);
            if (remaining > 0) {
                ItemStack remainingItem = this.plugin.getSpawnerManager().createSpawner(entityType, remaining);
                this.giveOrDrop(player, remainingItem);
            }
            String entityName = SpawnerUtils.getEntityDisplayName(entityType);
            player.sendMessage(this.plugin.getLocaleManager().getMessage("spawner.stacked", "type", entityName, "amount", String.valueOf(appliedStack)));
            return;
        }
        CreatureSpawner spawner = (CreatureSpawner)blockPlaced.getState();
        spawner.setSpawnedType(entityType);
        PersistentDataContainer container = spawner.getPersistentDataContainer();
        container.set(this.plugin.getSpawnerManager().getOwnerKey(), PersistentDataType.STRING, (Object)player.getName());
        int appliedStack = Math.min(itemStackSize, maxStack);
        int remaining = itemStackSize - appliedStack;
        container.set(this.plugin.getSpawnerManager().getStackKey(), PersistentDataType.INTEGER, (Object)appliedStack);
        this.plugin.getSpawnerManager().applyStackToSpawner(spawner, appliedStack);
        spawner.update();
        this.plugin.getSpawnerManager().updateSpawnerHologram(blockPlaced, entityType, appliedStack);
        if (remaining > 0) {
            ItemStack remainingItem = this.plugin.getSpawnerManager().createSpawner(entityType, remaining);
            this.giveOrDrop(player, remainingItem);
        }
        String entityName = SpawnerUtils.getEntityDisplayName(entityType);
        player.sendMessage(this.plugin.getLocaleManager().getMessage("spawner.placed", "type", entityName));
    }

    private void consumeItem(Player player, ItemStack item) {
        if (item.getAmount() > 1) {
            item.setAmount(item.getAmount() - 1);
        } else {
            player.getInventory().setItemInMainHand(null);
        }
    }

    private void giveOrDrop(Player player, ItemStack item) {
        if (player.getInventory().firstEmpty() != -1) {
            player.getInventory().addItem(new ItemStack[]{item});
        } else {
            player.getWorld().dropItemNaturally(player.getLocation(), item);
        }
    }
}

