/*
 * Decompiled with CFR 0.152.
 */
package com.spawnerx.listeners;

import com.spawnerx.SpawnerX;
import com.spawnerx.utils.SpawnerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class SpawnerInteractListener
implements Listener {
    private final SpawnerX plugin;
    private final Map<UUID, BukkitTask> activeMenus = new HashMap<UUID, BukkitTask>();
    private final Map<UUID, Block> playerSpawnerMap = new HashMap<UUID, Block>();

    public SpawnerInteractListener(SpawnerX plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || block.getType() != Material.SPAWNER) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.isSneaking()) {
            return;
        }
        event.setCancelled(true);
        this.openSpawnerMenu(player, block);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (this.activeMenus.containsKey(event.getWhoClicked().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (this.activeMenus.containsKey(event.getWhoClicked().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        if (this.activeMenus.containsKey(uuid)) {
            this.activeMenus.get(uuid).cancel();
            this.activeMenus.remove(uuid);
            this.playerSpawnerMap.remove(uuid);
        }
    }

    private void openSpawnerMenu(final Player player, final Block block) {
        CreatureSpawner spawner = (CreatureSpawner)block.getState();
        EntityType entityType = spawner.getSpawnedType();
        String entityName = SpawnerUtils.getEntityDisplayName(entityType);
        String title = this.plugin.getLocaleManager().getMessage("menu.title", "type", entityName);
        final Inventory gui = Bukkit.createInventory(null, (int)27, (Component)LegacyComponentSerializer.legacyAmpersand().deserialize(title));
        ItemStack glass = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta glassMeta = glass.getItemMeta();
        if (glassMeta != null) {
            glassMeta.displayName((Component)Component.text((String)" "));
            glass.setItemMeta(glassMeta);
        }
        for (int i = 0; i < gui.getSize(); ++i) {
            gui.setItem(i, glass);
        }
        PersistentDataContainer container = spawner.getPersistentDataContainer();
        String ownerName = (String)container.get(this.plugin.getSpawnerManager().getOwnerKey(), PersistentDataType.STRING);
        if (ownerName != null) {
            ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
            SkullMeta skullMeta = (SkullMeta)skull.getItemMeta();
            if (skullMeta != null) {
                skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)ownerName));
                skullMeta.displayName((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getLocaleManager().getMessage("menu.owner-item.name", "player", ownerName)));
                ArrayList<TextComponent> skullLore = new ArrayList<TextComponent>();
                skullLore.add(LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getLocaleManager().getMessage("menu.owner-item.lore")));
                skullMeta.lore(skullLore);
                skull.setItemMeta((ItemMeta)skullMeta);
            }
            gui.setItem(15, skull);
        }
        player.openInventory(gui);
        this.playerSpawnerMap.put(player.getUniqueId(), block);
        BukkitTask task = new BukkitRunnable(this){
            final /* synthetic */ SpawnerInteractListener this$0;
            {
                SpawnerInteractListener spawnerInteractListener = this$0;
                Objects.requireNonNull(spawnerInteractListener);
                this.this$0 = spawnerInteractListener;
            }

            public void run() {
                if (!player.isOnline() || player.getOpenInventory().getTopInventory() != gui) {
                    this.cancel();
                    this.this$0.activeMenus.remove(player.getUniqueId());
                    this.this$0.playerSpawnerMap.remove(player.getUniqueId());
                    return;
                }
                this.this$0.updateMenu(player, gui, block);
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 10L);
        this.activeMenus.put(player.getUniqueId(), task);
    }

    private void updateMenu(Player player, Inventory gui, Block block) {
        if (block.getType() != Material.SPAWNER) {
            player.closeInventory();
            return;
        }
        CreatureSpawner spawner = (CreatureSpawner)block.getState();
        EntityType entityType = spawner.getSpawnedType();
        String entityName = SpawnerUtils.getEntityDisplayName(entityType);
        PersistentDataContainer container = spawner.getPersistentDataContainer();
        int stack = (Integer)container.getOrDefault(this.plugin.getSpawnerManager().getStackKey(), PersistentDataType.INTEGER, (Object)1);
        ItemStack info = new ItemStack(Material.SPAWNER);
        ItemMeta meta = info.getItemMeta();
        if (meta != null) {
            meta.displayName((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getLocaleManager().getMessage("menu.info-item.name", "type", entityName)));
            String rarity = this.plugin.getConfigManager().getRarity(entityType.name());
            String rarityClean = rarity.replaceAll("&[0-9a-fk-or]", "");
            String rarityColor = this.extractColorCode(rarity);
            ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
            lore.add(Component.empty());
            lore.add(LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getLocaleManager().getMessage("spawner.lore.info")));
            lore.add(LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getLocaleManager().getMessage("spawner.lore.type", "type", entityName)));
            lore.add(LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getLocaleManager().getMessage("spawner.lore.rarity", "rarity", rarityClean, "rarity_color", rarityColor)));
            lore.add(LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getLocaleManager().getMessage("spawner.lore.stack", "amount", String.valueOf(stack))));
            int activeDistance = this.plugin.getConfigManager().getSpawnerActiveDistance();
            boolean playerNearby = false;
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.getWorld().equals((Object)block.getWorld()) || !(p.getLocation().distance(block.getLocation()) <= (double)activeDistance)) continue;
                playerNearby = true;
                break;
            }
            int spawnRange = spawner.getSpawnRange();
            int maxNearby = spawner.getMaxNearbyEntities();
            long nearbyCount = block.getWorld().getNearbyEntities(block.getLocation().add(0.5, 0.5, 0.5), (double)spawnRange, (double)spawnRange, (double)spawnRange).stream().filter(entity -> entity.getType() == entityType).count();
            boolean belowCap = maxNearby <= 0 || nearbyCount < (long)maxNearby;
            boolean validEnvironment = playerNearby && belowCap;
            String envStatus = this.plugin.getLocaleManager().getMessage(validEnvironment ? "menu.status.valid" : "menu.status.invalid");
            lore.add(LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getLocaleManager().getMessage("menu.info-item.environment", "status", envStatus)));
            lore.add(Component.empty());
            meta.lore(lore);
            info.setItemMeta(meta);
        }
        gui.setItem(13, info);
        ItemStack dynamicInfo = new ItemStack(Material.CLOCK);
        ItemMeta dynamicMeta = dynamicInfo.getItemMeta();
        if (dynamicMeta != null) {
            dynamicMeta.displayName((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getLocaleManager().getMessage("menu.dynamic.title")));
            ArrayList<TextComponent> dynamicLore = new ArrayList<TextComponent>();
            int delay = spawner.getDelay();
            int minDelay = spawner.getMinSpawnDelay();
            int maxDelay = spawner.getMaxSpawnDelay();
            int activeDistance = this.plugin.getConfigManager().getSpawnerActiveDistance();
            boolean active = false;
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.getWorld().equals((Object)block.getWorld()) || !(p.getLocation().distance(block.getLocation()) <= (double)activeDistance)) continue;
                active = true;
                break;
            }
            dynamicLore.add(Component.empty());
            dynamicLore.add(LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getLocaleManager().getMessage("menu.dynamic.spawn-tick", "delay", String.valueOf(delay))));
            dynamicLore.add(LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getLocaleManager().getMessage("menu.dynamic.spawn-time", "min", String.valueOf(minDelay / 20), "max", String.valueOf(maxDelay / 20))));
            String activeStatus = this.plugin.getLocaleManager().getMessage(active ? "menu.dynamic.status-active" : "menu.dynamic.status-inactive");
            dynamicLore.add(LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getLocaleManager().getMessage("menu.dynamic.status", "status", activeStatus)));
            dynamicLore.add(Component.empty());
            dynamicLore.add(LegacyComponentSerializer.legacyAmpersand().deserialize(this.plugin.getLocaleManager().getMessage("menu.dynamic.footer")));
            dynamicMeta.lore(dynamicLore);
            dynamicInfo.setItemMeta(dynamicMeta);
        }
        gui.setItem(11, dynamicInfo);
    }

    private String extractColorCode(String rarity) {
        int idx = rarity.indexOf("&");
        if (idx >= 0 && idx + 1 < rarity.length()) {
            return rarity.substring(idx, idx + 2);
        }
        return "&f";
    }
}

