/*
 * Decompiled with CFR 0.152.
 */
package com.spawnerx.listeners;

import com.spawnerx.SpawnerX;
import com.spawnerx.utils.SpawnerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class SpawnerExplosionListener
implements Listener {
    private final SpawnerX plugin;
    private final Random random;

    public SpawnerExplosionListener(SpawnerX plugin) {
        this.plugin = plugin;
        this.random = new Random();
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        this.handleExplosion(event.blockList());
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockExplode(BlockExplodeEvent event) {
        this.handleExplosion(event.blockList());
    }

    private void handleExplosion(List<Block> blocks) {
        if (!this.plugin.getConfigManager().isExplosionDropAllowed()) {
            return;
        }
        double dropChance = this.plugin.getConfigManager().getExplosionDropChance();
        ArrayList<Block> spawnersToRemove = new ArrayList<Block>();
        for (Block block : blocks) {
            if (block.getType() != Material.SPAWNER) continue;
            CreatureSpawner spawner = (CreatureSpawner)block.getState();
            EntityType entityType = spawner.getSpawnedType();
            PersistentDataContainer container = spawner.getPersistentDataContainer();
            int stack = (Integer)container.getOrDefault(this.plugin.getSpawnerManager().getStackKey(), PersistentDataType.INTEGER, (Object)1);
            int droppedCount = 0;
            for (int i = 0; i < stack; ++i) {
                double roll = this.random.nextDouble() * 100.0;
                if (!(roll <= dropChance)) continue;
                ItemStack spawnerItem = this.plugin.getSpawnerManager().createSpawner(entityType, 1);
                block.getWorld().dropItemNaturally(block.getLocation(), spawnerItem);
                ++droppedCount;
            }
            if (droppedCount > 0) {
                String entityName = SpawnerUtils.getEntityDisplayName(entityType);
                this.plugin.getLogger().info("Spawner de " + entityName + " (x" + stack + ") destru\u00eddo por explos\u00e3o. " + droppedCount + " itens dropados em " + block.getLocation().getBlockX() + ", " + block.getLocation().getBlockY() + ", " + block.getLocation().getBlockZ());
            }
            this.plugin.getSpawnerManager().removeSpawnerHologram(block);
            spawnersToRemove.add(block);
        }
        for (Block spawnerBlock : spawnersToRemove) {
            spawnerBlock.setType(Material.AIR);
            blocks.remove(spawnerBlock);
        }
    }
}

