/*
 * Decompiled with CFR 0.152.
 */
package com.spawnerx.listeners;

import com.spawnerx.SpawnerX;
import org.bukkit.Location;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.SpawnerSpawnEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class SpawnerDistanceListener
implements Listener {
    private final SpawnerX plugin;

    public SpawnerDistanceListener(SpawnerX plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSpawnerSpawn(SpawnerSpawnEvent event) {
        boolean playerNearby;
        CreatureSpawner spawner = event.getSpawner();
        if (spawner == null) {
            return;
        }
        PersistentDataContainer container = spawner.getPersistentDataContainer();
        if (!container.has(this.plugin.getSpawnerManager().getStackKey(), PersistentDataType.INTEGER)) {
            return;
        }
        int distance = this.plugin.getConfigManager().getSpawnerActiveDistance();
        Location location = spawner.getLocation();
        boolean bl = playerNearby = !location.getWorld().getNearbyPlayers(location, (double)distance).isEmpty();
        if (!playerNearby) {
            event.setCancelled(true);
        }
    }
}

