/*
 * Decompiled with CFR 0.152.
 */
package com.spawnerx.listeners;

import com.spawnerx.SpawnerX;
import com.spawnerx.utils.SpawnerUtils;
import java.util.List;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class SpawnerBreakListener
implements Listener {
    private final SpawnerX plugin;
    private final Random random = new Random();

    public SpawnerBreakListener(SpawnerX plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSpawnerBreak(BlockBreakEvent event) {
        boolean dropStacked;
        Block block = event.getBlock();
        if (block.getType() != Material.SPAWNER) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.hasPermission("spawnerx.spawner.break")) {
            event.setCancelled(true);
            player.sendMessage(this.plugin.getLocaleManager().getMessage("break.no-permission"));
            return;
        }
        ItemStack tool = player.getInventory().getItemInMainHand();
        List<Material> validTools = this.plugin.getConfigManager().getValidTools();
        boolean hasTool = validTools.contains(tool.getType());
        boolean hasSilk = !this.plugin.getConfigManager().requiresSilkTouch() || tool.containsEnchantment(Enchantment.SILK_TOUCH);
        boolean meetsRequirements = hasTool && hasSilk;
        CreatureSpawner spawner = (CreatureSpawner)block.getState();
        EntityType entityType = spawner.getSpawnedType();
        PersistentDataContainer container = spawner.getPersistentDataContainer();
        int currentStack = (Integer)container.getOrDefault(this.plugin.getSpawnerManager().getStackKey(), PersistentDataType.INTEGER, (Object)1);
        if (!meetsRequirements) {
            if (this.plugin.getConfigManager().isAllowBreakWithoutRequirements()) {
                String entityName = SpawnerUtils.getEntityDisplayName(entityType);
                player.sendMessage(this.plugin.getLocaleManager().getMessage("break.success-no-req", "type", entityName));
                player.playSound(player.getLocation(), Sound.ENTITY_ITEM_BREAK, 1.0f, 1.0f);
                this.plugin.getSpawnerManager().removeSpawnerHologram(block);
                return;
            }
            event.setCancelled(true);
            if (!hasTool) {
                player.sendMessage(this.plugin.getLocaleManager().getMessage("break.wrong-tool"));
            } else if (!hasSilk) {
                player.sendMessage(this.plugin.getLocaleManager().getMessage("break.no-silk-touch"));
            }
            return;
        }
        event.setDropItems(false);
        event.setExpToDrop(0);
        double chance = this.plugin.getConfigManager().getBreakDropChance();
        boolean shouldDrop = this.random.nextDouble() * 100.0 <= chance;
        boolean bl = dropStacked = currentStack > 1 && player.isSneaking();
        if (shouldDrop) {
            int dropSize = dropStacked ? currentStack : 1;
            ItemStack spawnerItem = this.plugin.getSpawnerManager().createSpawner(entityType, dropSize);
            if (this.plugin.getConfigManager().isBreakDropToInventory()) {
                if (player.getInventory().firstEmpty() != -1) {
                    player.getInventory().addItem(new ItemStack[]{spawnerItem});
                } else {
                    block.getWorld().dropItemNaturally(block.getLocation(), spawnerItem);
                }
            } else {
                block.getWorld().dropItemNaturally(block.getLocation(), spawnerItem);
            }
            player.sendMessage(this.plugin.getLocaleManager().getMessage("break.success", "type", SpawnerUtils.getEntityDisplayName(entityType)));
        } else {
            player.sendMessage(this.plugin.getLocaleManager().getMessage("break.fail-chance", "type", SpawnerUtils.getEntityDisplayName(entityType)));
        }
        if (dropStacked) {
            this.plugin.getSpawnerManager().removeSpawnerHologram(block);
            return;
        }
        if (currentStack > 1) {
            event.setCancelled(true);
            int newStack = currentStack - 1;
            container.set(this.plugin.getSpawnerManager().getStackKey(), PersistentDataType.INTEGER, (Object)newStack);
            this.plugin.getSpawnerManager().applyStackToSpawner(spawner, newStack);
            spawner.update();
            this.plugin.getSpawnerManager().updateSpawnerHologram(block, entityType, newStack);
            player.playSound(player.getLocation(), Sound.BLOCK_STONE_BREAK, 1.0f, 1.0f);
            return;
        }
        this.plugin.getSpawnerManager().removeSpawnerHologram(block);
    }
}

