/*
 * Decompiled with CFR 0.152.
 */
package com.spawnerx.commands;

import com.spawnerx.SpawnerX;
import com.spawnerx.utils.SpawnerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SpawnerXCommand
implements CommandExecutor,
TabCompleter {
    private final SpawnerX plugin;

    public SpawnerXCommand(SpawnerX plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": {
                return this.handleReload(sender);
            }
            case "give": {
                return this.handleGive(sender, args);
            }
            case "shop": {
                return this.handleShop(sender);
            }
            case "help": {
                this.sendHelp(sender);
                return true;
            }
        }
        sender.sendMessage(this.plugin.getLocaleManager().getMessage("general.invalid-usage", "usage", "/" + label + " [reload|give|shop|help]"));
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("spawnerx.admin")) {
            sender.sendMessage(this.plugin.getLocaleManager().getMessage("commands.no-permission"));
            return true;
        }
        try {
            this.plugin.reload();
            sender.sendMessage(this.plugin.getLocaleManager().getMessage("commands.reload.success"));
        }
        catch (Exception e) {
            sender.sendMessage(this.plugin.getLocaleManager().getMessage("commands.reload.error"));
            this.plugin.getLogger().severe("Erro ao recarregar configura\u00e7\u00e3o: " + e.getMessage());
        }
        return true;
    }

    private boolean handleGive(CommandSender sender, String[] args) {
        if (!sender.hasPermission("spawnerx.admin")) {
            sender.sendMessage(this.plugin.getLocaleManager().getMessage("commands.no-permission"));
            return true;
        }
        if (args.length < 3) {
            sender.sendMessage(this.plugin.getLocaleManager().getMessage("general.invalid-usage", "usage", "/spawnerx give <player> <mob>"));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            sender.sendMessage(this.plugin.getLocaleManager().getMessage("commands.give.player-not-found", "player", args[1]));
            return true;
        }
        EntityType entityType = SpawnerUtils.getEntityType(args[2]);
        if (entityType == null || !SpawnerUtils.isMobEntityType(entityType)) {
            sender.sendMessage(this.plugin.getLocaleManager().getMessage("commands.give.invalid-mob", "type", args[2]));
            return true;
        }
        int amount = 1;
        if (args.length >= 4) {
            try {
                amount = Integer.parseInt(args[3]);
                if (amount < 1) {
                    amount = 1;
                }
            }
            catch (NumberFormatException e) {
                amount = 1;
            }
        }
        ItemStack spawner = this.plugin.getSpawnerManager().createSpawner(entityType);
        spawner.setAmount(amount);
        target.getInventory().addItem(new ItemStack[]{spawner});
        String entityName = SpawnerUtils.getEntityDisplayName(entityType);
        sender.sendMessage(this.plugin.getLocaleManager().getMessage("commands.give.success", "amount", String.valueOf(amount), "type", entityName, "player", target.getName()));
        target.sendMessage(this.plugin.getLocaleManager().getMessage("commands.give.received", "amount", String.valueOf(amount), "type", entityName));
        return true;
    }

    private boolean handleShop(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getLocaleManager().getMessage("shop.only-players"));
            return true;
        }
        if (!sender.hasPermission("spawnerx.shop")) {
            sender.sendMessage(this.plugin.getLocaleManager().getMessage("commands.no-permission"));
            return true;
        }
        this.plugin.getSpawnerShopManager().openShop((Player)sender);
        return true;
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(this.plugin.getLocaleManager().getMessage("commands.help.header"));
        sender.sendMessage(this.plugin.getLocaleManager().getMessage("commands.help.reload"));
        sender.sendMessage(this.plugin.getLocaleManager().getMessage("commands.help.give"));
        sender.sendMessage(this.plugin.getLocaleManager().getMessage("commands.help.shop"));
        sender.sendMessage(this.plugin.getLocaleManager().getMessage("commands.help.help"));
        sender.sendMessage(this.plugin.getLocaleManager().getMessage("commands.help.footer"));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.addAll(Arrays.asList("reload", "give", "shop", "help"));
            return completions.stream().filter(s -> s.toLowerCase().startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args[0].equalsIgnoreCase("give")) {
            if (args.length == 2) {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
            if (args.length == 3) {
                return Arrays.stream(EntityType.values()).filter(SpawnerUtils::isMobEntityType).map(Enum::name).filter(name -> name.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList());
            }
            if (args.length == 4) {
                return Arrays.asList("1", "2", "5", "10", "32", "64");
            }
        }
        return completions;
    }
}

